// File.h: interface for the CFile class.
//
//////////////////////////////////////////////////////////////////////
#pragma	once


class CFile  {

public:

	CFile();
	virtual ~CFile();

	virtual bool Open(const tstring &sFileName, 
			DWORD dwFileAccess = GENERIC_READ | GENERIC_WRITE,
			DWORD dwCreationDisposition = OPEN_ALWAYS,
			DWORD dwFlagsAndAttributes = FILE_ATTRIBUTE_NORMAL );

	virtual bool Close();

	virtual bool Write(LPCVOID lpData, DWORD dwLen);

	virtual bool WriteStringAsOem(LPCTSTR szData);
	virtual bool WriteOemString(const char* szData);

	virtual bool SeekToEnd();

protected:

	HANDLE	m_hFile;

};


class COemLineReader {

public:

	COemLineReader(LPCTSTR fileName);
	virtual ~COemLineReader();

	inline bool isOpened() { return (fileHandle != INVALID_HANDLE_VALUE); }

	bool next();

	LPCSTR	getLine();

protected:
	HANDLE	fileHandle;
	DWORD	bufferSize;
	LPSTR	buffer;
	LPSTR	line;	// line is always stored in bufferSize+1 bytes
	DWORD	startPos;
	DWORD	dataSize;
	/**
	 * End-of-file flag
	 */
	bool	eof;

	/**
	 * Gets end-of-line position (CR index of CRLF or LF) in buffer, starting search from startPos during dataSize
	 * eolSearchOffset determines offset to start search from
	 * Returns -1 if not found
	 */
	int getEolPos(int eolSearchOffset);
	/**
	 * Reads more data, growing buffer if needed. startPos and dataSize can be changed
	 * Returns false when there is no more data or error occured
	 */
	bool readMore();

	/**
	 * Remembers line from startPos to eolPos-1
	 */
	void rememberLine(int eolPos);
};
